package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.File;
import java.util.ArrayList;

public class HorizontalBlockScreenPaletteObject extends
		MobileScreenPaletteObject {

	private boolean shouldBePassThru;
	private int defaultSpeed;
	private String fileName;

	private ArrayList<ScreenObject> allCreatedObjects;
	
	public HorizontalBlockScreenPaletteObject(IntRect theClickRect, 
										  	  int theDistanceToBorder, 
										  	  int theBorderWidth, 
										  	  int desiredWidth, 
										  	  int desiredHeight, 
										  	  String imageFileName, 
										  	  Color transColor,
										  	  ImageObserver io,
										  	  boolean passThru,
										  	  int theDefaultSpeed,
										  	  String theFileName) {
		
		clickRect = theClickRect;
		fileName = theFileName;
		image = new CustomImageDataII(new File(imageFileName), transColor, io, desiredWidth, desiredHeight);
		
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		
		shouldBePassThru = passThru;
		
		defaultSpeed = theDefaultSpeed;
		
		allCreatedObjects = new ArrayList<ScreenObject>();
		
	}
	
	
	
	@Override
	public ScreenObject create(int objX, int objY, ImageObserver io) {
		this.setMode(MobileScreenPaletteObject.SETTING_MIN);
		this.setConstructedObject(new HorizontalBlockScreenObject(objX, objY, 
			    image.getDesiredWidth(), image.getDesiredHeight(), 
			    this, shouldBePassThru, defaultSpeed));
		allCreatedObjects.add(this.getConstructedObject());
		return this.getConstructedObject();
	}

	@Override
	public void draw(Graphics g) {
		if(clickRect == null)
			return;
		
		Point p = clickRect.getCenter();
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		Color origCol = g.getColor();
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
	}



	public String getFileName() {
		return fileName;
	}



	public void setFileName(String fileName) {
		this.fileName = fileName;
	}



	public boolean shouldBePassThru() {
		return shouldBePassThru;
	}



	public void setShouldBePassThru(boolean shouldBePassThru) {
		this.shouldBePassThru = shouldBePassThru;
	}



	public int getDefaultSpeed() {
		return defaultSpeed;
	}



	public void setDefaultSpeed(int defaultSpeed) {
		this.defaultSpeed = defaultSpeed;
	}
	
	
	public void setImage(CustomImageDataII newImage) {
		image = newImage;
	}
	
	public CustomImageDataII getImage() {
		return image;
	}



	@Override
	public void delete(ScreenObject so) {

		for(int i = 0; i < allCreatedObjects.size(); i++) {
			if(allCreatedObjects.get(i).equals(so)) {
				allCreatedObjects.remove(i);
				return;
			}
		}
		
	}
	
	public void altered() {
		
		int width = image.getDesiredWidth();
		int height = image.getDesiredHeight();
		
		ScreenObject so = null;
		IntRect origRect = null;
		IntRect newRect = null;
		Point center = null;
		
		for(int i = 0; i < allCreatedObjects.size(); i++) {
			so = allCreatedObjects.get(i);
			origRect = so.getClickRect();
			if(origRect.width() == width && origRect.height() == height)
				continue;
			center = origRect.getCenter();
			newRect = new IntRect(center.x - width/2, center.y - height/2, width, height);
			so.setClickRect(newRect);
			if(so instanceof HorizontalBlockScreenObject) {
				((HorizontalBlockScreenObject)so).setShouldBePassthru(shouldBePassThru);
			}
				
		}
		
	}
	
	
	
}
